﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.BPR.QuestionTool
{
    public partial class ToolQuestionGroupPreview : BprBasePage
    {
        private ServiceInterfaceManager toolManager = new ServiceInterfaceManager();

        protected override void Page_Load(object sender, EventArgs e)
        {
            int formId = Request.QueryString["id"] == null ? 0 : Helpers.GetIntFromString(Request.QueryString["id"].ToString());
            HiddenFieldQuestionGroupId.Value = formId.ToString();
            LinkButtonQuestionGroupEdit.PostBackUrl = "ToolQuestionGroupEdit.aspx?id=" + formId.ToString();
            LinkButtonQuestionGroupEditBottom.PostBackUrl = "ToolQuestionGroupEdit.aspx?id=" + formId.ToString();
            LoadControlsFromObject(formId);
        }

        public void LoadControlsFromObject(int formId)
        {
            if (formId > 0)
            {
                var form = toolManager.GetFormById(formId);
                if (form != null)
                {
                    PanelPreview.GroupingText = "Preview Question Group - " + form.NAME + "&nbsp;&nbsp;";
                    List<VIRP.AHOBPR.BO.QuestionGroup> questions = new List<VIRP.AHOBPR.BO.QuestionGroup>();
                    List<SoaServices.TOOL_FORM_QUESTION> formQuestions = (from e in form.TOOL_FORM_QUESTIONs
                                                              orderby e.TOOL_FORM_QUESTION_ID
                                                              select e).ToList();
                    int order = 0;
                    foreach (SoaServices.TOOL_FORM_QUESTION item in form.TOOL_FORM_QUESTIONs)
                    {
                        order++;
                        VIRP.AHOBPR.BO.QuestionGroup question = new VIRP.AHOBPR.BO.QuestionGroup();
                        question.FormId = item.TOOL_FORM_ID.ToString();
                        question.QuestionId = item.TOOL_QUESTION_ID.ToString();
                        question.Sequence = order.ToString();
                        questions.Add(question);
                    }
                    RepeaterQuestionGroup.DataSource = questions;
                    RepeaterQuestionGroup.DataBind();
                    PanelPreview.Visible = true;
                    LinkButtonQuestionGroupEdit.Visible = form.EDITABLE_FLAG;
                    LinkButtonQuestionGroupEditBottom.Visible = form.EDITABLE_FLAG;
                }
            }
            else
            {
                PanelPreview.Visible = false;
            }
        }
        public override string TopMenuName()
        {
            return "Tool";
        }

        public override string MenuItemName()
        {
            return "Question Group List";
        }

        public override string AppObjectCode()
        {
            return "AHOBPR TOOL";
        }
    }
}